/**
* \file: mlink_dlt.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK DLT Adapter
*
* \component: mlink
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2013 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
*
***********************************************************************/


#ifndef _MLINK_DLT_H_
#define _MLINK_DLT_H_

#ifdef __cplusplus
extern "C"
{
#endif

#define VNC_USE_STDINT_H

#include <vncdiscoverysdk.h>
#include <vncwifidisplaysdk.h>
#include <vncviewersdk.h>
#include <vncaudiorouter.h>
#include <vnccdbsdk.h>
#include <vncdapsdk.h>

#include <endian.h>
#include <dlt/dlt.h>



typedef struct mlink_dlt_context mlink_dlt_context;


/**
 * \func mlink_dlt_initialize
 * This function initializes the DLT logging. It has to be called once before any
 * of the callback functions are called.
 *
 * \param Return DLT context to be stored in mlink_adapter_context. Null on error
 *
 */
mlink_dlt_context * mlink_dlt_initialize (void);


/**
 * \func mlink_dlt_finalize
 *
 * \param pContext context returned by mlink_dlt_initialize. The pointer is freed by the
 * function
 *
 */
void mlink_dlt_finalize (mlink_dlt_context * pContext);


/**
 * \func mlink_dlt_viewer_log_callback
 * log callback for RealVNC Viewer SDK
 * \param pContext pContext has to be of mlink_adapter_context with an valid dlt_ctx
 * \param pViewer Provided by RealVNC stack
 * \param category Provided by RealVNC stack
 * \param severity Provided by RealVNC stack
 * \param text Provided by RealVNC stack
 *
 */
void mlink_dlt_viewer_log_callback (VNCViewer *pViewer, void *pContext,
    const char *category, vnc_int32_t severity, const char *text);

/**
 * \func mlink_dlt_wifidisplay_log_callback
 * log callback for RealVNC WiFiDisplay SDK
 * \param VNCWiFiDisplaySink WiFiDisplay Sink object
 * \param pContext pContext has to be of mlink_adapter_context with an valid dlt_ctx
 * \param category Provided by RealVNC stack
 * \param severity Provided by RealVNC stack
 * \param text Provided by RealVNC stack
 *
 */
void mlink_dlt_wifidisplay_log_callback(VNCWiFiDisplaySink *wfdSink,
                                        void *pContext,
                                        const char *category,
                                        vnc_int32_t severity,
                                        const char *text);


/**
 * \func mlink_dlt_dap_log_callback
 * log callback for RealVNC DAP SDK
 * \param pContext pContext has to be of mlink_adapter_context with an valid dlt_ctx
 * \param pVNCDAPClient Provided by RealVNC stack
 * \param category Provided by RealVNC stack
 * \param severity Provided by RealVNC stack
 * \param text Provided by RealVNC stack
 *
 */
void  mlink_dlt_dap_log_callback(VNCDAPClient *pVNCDAPClient, void *pContext,
    const char *category, vnc_int32_t severity, const char *text);


/**
 * \func mlink_dlt_cdb_log_callback
 * log callback for RealVNC CDB SDK
 * \param pContext pContext has to be of mlink_adapter_context with an valid dlt_ctx
 * \param pEndpoint Provided by RealVNC stack
 * \param category Provided by RealVNC stack
 * \param severity Provided by RealVNC stack
 * \param text Provided by RealVNC stack
 *
 */
void mlink_dlt_cdb_log_callback(VNCCDBEndpoint *pEndpoint, void *pContext,
    const char *category, vnc_int32_t severity, const char *text);


/**
 * \func mlink_discovery_cdb_log_callback
 * log callback for RealVNC Discovery SDK
 * \param pSDKContext pSDKContext has to be of mlink_adapter_context with an valid dlt_ctx
 * \param severity Provided by RealVNC stack
 * \param pDiscoverer Provided by RealVNC stack
 * \param text Provided by RealVNC stack
 *
 */
void mlink_dlt_discovery_log_callback (void *pSDKContext, vnc_int32_t severity,
    const char *pDiscoverer, const char *pText);

/**
 * \func mlink_audiorouter_cdb_log_callback
 * log callback for RealVNC audiorouter SDK
 * \param pContext pContext has to be of mlink_adapter_context with an valid dlt_ctx
 * \param severity Provided by RealVNC stack
 * \param text Provided by RealVNC stack
 *
 */
void mlink_dlt_audiorouter_log_callback(void * pContext, vnc_int32_t severity,
    const char *text);


/**
 * \func mlink_dlt_get_dlt_context
 * Retrieve DLTContext from mlink_dlt component
 * \param pContext pContext has to be of mlink_adapter_context with an valid dlt_ctx
 * \param Return DltContext for direct use of DLT macros
 */
DltContext * mlink_dlt_get_dlt_context(mlink_dlt_context * pContext);

#ifdef __cplusplus
}
#endif

#endif /* _MLINK_DLT_H_ */
